# install.packages("ggplot2")

library(ggplot2)

# Set workspace
setwd("enter your folder here")

# Read text file
df <- read.csv(file="OM S20 dataset.csv",head=TRUE,sep=",")

# Print data frame
df

# Make plot
OMS20 <- ggplot() +
  geom_rect(aes(xmin=1028.5, xmax=1034.5, ymin=0, ymax=Inf)) +
  geom_point(data = df, aes(x = avgcmOD, y = X.OM), colour="black", size=2, shape=21, fill="violetred2") + 
  xlab(' ') +
  ylab('Organic matter content [%]') +
  geom_hline(yintercept=40,linetype="dashed",size=1) +
  geom_vline(xintercept=1029.5,linetype="dotted",size=1) +
  geom_vline(xintercept=1030.5,linetype="dotted",size=1) +
  xlim(1023.25, 1039) +
  ylim(0, 100) +
  coord_flip()

# Show plot
OMS20

# Save plot
ggsave("OMS20.pdf", plot=OMS20, height=17.5, width=10, units=c("cm"), dpi=600)